%function analysis_sinoidal2_20102016a(varargin)

% Varagin:
% plot_individual,'yes', saccade_variante,'1'or '2',plot_saccade_detection,
% 'yes'

clear all
close all

%path = 'C:\Users\Reb\Documents\Master\Data\'

repeats_sin = 10;
window_small = 500;
stimlength = 100;
[eye.filename, eye.pathname, ~] = uigetfile('*.txt');
eye.raw = load([eye.pathname eye.filename]);
stimuliorder = xlsread('Stimulusprotokolle.xls','D2:D99');
[~,~,position] = xlsread('Stimulusprotokolle.xls','B105:AR108');

eye.time     = eye.raw(:,1);
eye.time = eye.time - eye.time(1);
eye.leftpos  = eye.raw(:,5);
eye.rightpos = eye.raw(:,6);
eye.stim = eye.raw(:,7);

highorlow = eye.stim > 0;
change = diff(highorlow)~=0;
changeindex = [];
for i = 1:size(change)
    if change(i) == 1
    changeindex = [changeindex i];
    end
end

trialend = size(eye.stim,1);
changeindex = [changeindex trialend];
changeindexdifference = diff(changeindex);

threshold = 20
endindex = [];
startindex = [];
for i = 1:size(changeindexdifference,2)
    if changeindexdifference (i) > threshold 
     endindex = [endindex, changeindex(i)];
         if i < size(changeindexdifference,2)
            startindex = [startindex, changeindex(i+1)];
         end
    end
end


endindex = endindex(2:end);
starttime = eye.time(startindex);
endtime = eye.time(endindex);


meaningful = endtime - starttime > 0.9 * stimlength;
starttime = starttime(meaningful);
endtime = endtime(meaningful);
startindex = startindex(meaningful);
endindex = endindex(meaningful);

plot(eye.time,eye.stim)
hold on
plot([starttime, starttime], [0,5],'linewidth', 3, 'color', 'r' )
plot([endtime, endtime], [0,5],':','linewidth', 3, 'color', [1 .5 .5])
hold off


% this parameters should be the same as in 'Final_Stimulus'
vel_peak2 = 10;        
framerate = 10;        
step = 1/framerate;             
vel_peak=vel_peak2/framerate;
T = 10; 

% if strcmp (plot_individual,'yes')
for i = 1:size(startindex,2)
  
   figure (1+i)
   hold on
   plot(eye.time(startindex(i): endindex(i)),eye.leftpos(startindex(i): endindex(i)))
   test = (diff(eye.leftpos(startindex(i): endindex(i))));
   testzeit =(diff(eye.time(startindex(i): endindex(i))));
   eye.velocity = test./ testzeit;
   cellindex = stimuliorder(i)+1;

% figure out which stimuli phase was presented here
% print the degrees associated with this stimulus phase

   type = num2str(position{2,cellindex});
   alpha = num2str(position{3,cellindex});
   if strcmp (alpha,'NaN')
       alpha = '';
   end
   beta = num2str(position{4,cellindex});
      if strcmp (beta,'NaN')
       beta = '';
   end
   if stimuliorder(i) ~= position{1,cellindex}
       error('Die sind gar nicht gleich...')
   end
   number = num2str(position{1,cellindex});
   
   label = {['Type ' type];['Alpha ', alpha];['Beta ', beta]; ['Stim ', number]};
   text (.9,.9,label,'units', 'normalized')
   

n = (endtime(i)-starttime(i));
x2 = (0:step:n);
x=(starttime(i):step:endtime(i));
vel = (vel_peak* sin(((2*pi*T)/n)*x2)+ eye.leftpos(startindex(i)));
plot(x,vel)
hold off
   
end
% end
eyeposition = eye.leftpos;

% Find saccades

  threshold = 1; 
%   toleranz = 3;
%   window_small = 10;
  toleranz = round(window_small/10) % beshcreibt die Anzahl der unerwnschten Ereignisse nach einer Saccade in 'window'
                              % welche noch hingenommen werden knnen
                              % (siehe unten)
  window_big = 1 % window zur berprfung des Bereiches um die Saccade
  toleranz_small = 5
  toleranz_big = toleranz_small+1
  window_small = window_big % so kann die Fensterlnge in Zukunft gendert werden
                              
  candidateindex = find(abs(diff(eyeposition)) > threshold);
  candidatetime = eye.time(candidateindex);

% %   saccadetime(fakesaccades) = [];
%   for i = 1: numel(candidatetime)
%       indexsaccade(i) = min(find(eye.time==candidatetime(i)));
%   end
 
% wenn mehrere aufeinanderfolgende zeitpunkte als mglich Saccaden erkannt
% werden, dann nutze killthese um alle bis auf den jeweils ersten dieser
% zeitpunkte zu entfernen.

 killthese = find(diff(candidateindex)<=1) + 1;
 candidateindex(killthese) = [];
 candidatetime(killthese) = [];
  

badsaccadeindex = [];
  for i = 1: numel(candidatetime)
      % Fr jeden mglichen verbliebenden Saccadenzeitpunkt, betrachte ein
      % Zeitfenster der Lnge 'window' (von:bis). Stelle dabei sicher, dass
      % das Fenster nicht lnger ist als die verbliebenden Datenpunkte
      % (durch Vergleich von 'bis' mit 'numel(eyeposition)').
      von = candidateindex(i);
      bis = candidateindex(i)+ window_small;
      bis = min(bis,numel(eyeposition));
      
      % Suche weitere groe Vernderungen von Schritt zu Schritt innerhalb
      % diese Zeitfensters, und speichere diese als binren Vektor in einer
      % Zelle. Die Schwelle fr 'groe' Vernderungen kann die selbe sein
      % wie fr die ursprngliche Saccadendetektion ('threshold'), muss es
      % aber nicht. (Man knnte hierfr auch einen neuen Schwellenwert
      % angeben)
      bigchangesinwindow {i} = abs(diff( eyeposition(von:bis)))> threshold;
      
      % Finde heraus welche zeitpunkte innerhalb eines Zeitfensters nach
      % der Saccade Vernderungen der Augenpositionen aufweisen, die
      % entweder in die gleiche oder in die entgegengesetzte Richtung der
      % Saccade stattfanden. Dazu rechnet zunchst die Richtung der
      % Vernderung der Augenposition in jedem Zeitschritt (ist sie poitiv
      % oder negativ? dass heit geht sie nach links oder rechts?)'signofchangeinwindow'.
      % Vergleiche diese Richtungen dann mit der Richtung der Saccade indem
      % man sie durch die Richtung der Saccade teilt 'relativchangeinwindow'. Dann erstelle einen
      % binren Vector, der nur Vernderungen in Richtung der Saccade
      % angibt, und einen zweiten Vector der nur Vernderungen entgegen der
      % Richtung der Sacccade angibt.
      
       signofchangeinwindow= (sign(diff(eyeposition(von:bis))));
       relativchangeinwindow = signofchangeinwindow/signofchangeinwindow(1);
       indexsamedirection_as_saccade = relativchangeinwindow == 1;
       indexdiffdirection_than_saccade = relativchangeinwindow== -1;
       bigchangesinwindow_logical = cell2mat(bigchangesinwindow(i));
       
       index_big_and_same_direction  = indexsamedirection_as_saccade (2:end).* bigchangesinwindow_logical(2:end);
       index_big_and_diff_direction  = indexdiffdirection_than_saccade (2:end).* bigchangesinwindow_logical(2:end);
       
       % for varaiant 2
       % Parameters for forward and backward window
       
       von_big = candidateindex(i)-window_big;
       bis_big = candidateindex(i)+ window_big;
       bis_big = min(bis_big,numel(eyeposition));
       von_big = max(1,i-window_big);
       range = von_big:bis_big;
       %range(candidateindex(i)) = []; 
       bigchangesinwindow_big {i} = abs(diff( eyeposition(von_big:bis_big)))> threshold;
       
       signofchangeinwindow_big= (sign(diff(eyeposition(range))));
       relativchangeinwindow_big = signofchangeinwindow_big/signofchangeinwindow_big(1);
       indexsamedirection_as_saccade_big = relativchangeinwindow_big == 1;
       indexdiffdirection_than_saccade_big = relativchangeinwindow_big == -1;
       bigchangesinwindow_logical_big = cell2mat(bigchangesinwindow_big(i));

       index_big_and_diff_direction_big  = indexdiffdirection_than_saccade_big.* bigchangesinwindow_logical_big;
       
       
       %parameters for small window
       
       von_small = candidateindex(i)-window_small;
       bis_small = candidateindex(i)+ window_small;
       bis_small = min(bis_small,numel(eyeposition));
       
       bigchangesinwindow_small {i} = abs(diff( eyeposition(von_small:bis_small)))> threshold;
       
       signofchangeinwindow_small = (sign(diff(eyeposition(von_small:bis_small))));
       relativchangeinwindow_small = signofchangeinwindow_small/signofchangeinwindow_small(1);
       indexsamedirection_as_saccade_small = relativchangeinwindow_small == 1;
       indexdiffdirection_than_saccade_small = relativchangeinwindow_small == -1;
       bigchangesinwindow_logical_small = cell2mat(bigchangesinwindow_small(i));
       
       index_big_and_same_direction_small  = indexsamedirection_as_saccade_small (2:end).* bigchangesinwindow_logical_small(2:end);
       index_big_and_diff_direction_small  = indexdiffdirection_than_saccade_small (2:end).* bigchangesinwindow_logical_small(2:end);
       
       % Variante 1:
       % Falls im gewhltem Fenster eine oder mehrere groe Vernderungen
       % in die Gegenrichtung der Saccade auftreten, dann halten wir weder
       % diese groen Vernderungen noch die vermeintlich ursprngliche
       % Saccade fr eine Saccade. Daher entfernen wir diese Zeitpunkte aus
       % 'candidateindex' und 'candidatetime'. Dies bedeutet auch, dass
       % diese weder als Saccaden gezhlt werden, noch die Rohdaten an
       % dieser Stelle ausgeschnitten werden.
       
       %if strcmp (saccade_variante,'1')
%         if sum (index_big_and_diff_direction) > toleranz
%              badsaccadeindex = [badsaccadeindex i]; % diese Zeile killt die erste Saccade aber nicht die weiteren Ereignisse !in bearbeitung!
%                  
%         end
      % end
        
            
       % Variante 2
       % Falls im gewhltem Fenster eine oder mehrere groe Vernderungen
       % in die Gegenrichtung der Saccade auftreten, dann halten wir sie
       % zunchst alle fr mgliche Saccaden. Wenn mehrere solche
       % Vernderungen auftreten, dann werden sie mit fortlaufendem Index i
       % in den folgenden Iterationen des Loops noch auf die brigen
       % Kriterien berprft. Dies ist also keine entgltige Entscheidung
       % pro Saccade. Wir entscheiden uns nur sie noch nicht zu entsorgen.
       
       %if strcmp (saccade_variante,'2')
        if sum (index_big_and_diff_direction_small) > toleranz_small && sum (index_big_and_diff_direction_big) > toleranz_big
           badsaccadeindex = [badsaccadeindex i]; 
        end
        if sum (index_big_and_diff_direction_small) <= toleranz_small && sum (index_big_and_diff_direction_big (1:(candidateindex(i)-von_big+1))) > 0
            badsaccadeindex = [badsaccadeindex i]; 
        end
         if sum (index_big_and_diff_direction_small) > toleranz_small && sum (index_big_and_diff_direction_big(((candidateindex(i)-von_big+1):end))) > toleranz_big
            badsaccadeindex = [badsaccadeindex i]; 
        end
   
       %end

  end
 
candidatetime(badsaccadeindex) = [];
candidateindex(badsaccadeindex) = [];

 % velocity calculating
 


  
%    for  t = 1:  size(saccadetime) 
%        indexsaccade(t) = find(eye.time==saccadetime(t))
% %        crop = eyeposition(indexsaccade(t-1) : indexsaccade(t))
%    end
%    
% 
%    for t = 2 :numel(indexsaccade) 
%         crop = eyeposition(indexsaccade(t-1) : indexsaccade(t))
%    end
  
  
  % Finally, plot detected saccade times for visual inspection.
  %if strcmp (plot_saccade_detection,'yes')
  figure(21)
    clf
    set(gcf,'Color',[1 1 1],'Position',[10 10 1200 300],'Name','Eye position')
    axes('Position',[.04 .15 .94 .8])
    hold on
    plot(eye.time([1 end]),[0 0],'-k')
    plot(eye.time,eyeposition,'Color',[.2 .4 .8])
    yrange = get(gca,'YLim');
    for k = 1:numel(candidatetime)
      plot(candidatetime(k)*[1 1],yrange,'--','Color',[.8 .0 .0])
    end
    hold off
    set(gca,'XLim',eye.time([1 end]),'TickLength',[0 0])
    xlabel('time since trial onset  (sec)')
    ylabel('eye position  (degrees)')
    box on
  %end
%end
